/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output.bookshelf;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputAux;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputNets;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputNodes;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputPlacement;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputWeights;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class BookshelfOutput
extends Output {
    private String filePath;
    private final EditingPreferences ep;

    private BookshelfOutput(String filePath, EditingPreferences ep) {
        this.filePath = filePath;
        this.ep = ep;
    }

    @Override
    protected boolean writeCell(Cell cell, VarContext context) {
        boolean result = true;
        Job.getUserInterface().startProgressDialog("Export Bookshelf", null);
        String genericFileName = this.filePath.substring(0, this.filePath.indexOf("."));
        BookshelfOutputWriter[] writers = new BookshelfOutputWriter[]{new BookshelfOutputAux(genericFileName), new BookshelfOutputNodes(genericFileName, cell, this.ep), new BookshelfOutputPlacement(genericFileName, cell), new BookshelfOutputNets(genericFileName, cell), new BookshelfOutputWeights(genericFileName, cell)};
        int sortKey = 0;
        for (BookshelfOutputWriter writer : writers) {
            try {
                writer.write();
            }
            catch (IOException e) {
                this.errorLogger.logError("Could not write file " + writer.getFileName(), sortKey);
                ++sortKey;
            }
        }
        Job.getUserInterface().stopProgressDialog();
        return result;
    }

    public static String createBookshelfHeader(Bookshelf.BookshelfFiles fileType) {
        StringBuilder builder = new StringBuilder();
        builder.append("Electric ");
        builder.append(fileType.toString());
        builder.append("\n");
        builder.append("# Created     : ");
        builder.append(DateFormat.getDateInstance(1).format(new Date(System.currentTimeMillis())));
        builder.append("\n");
        builder.append("# User        : ");
        builder.append(System.getProperty("user.name"));
        builder.append("\n");
        builder.append("# Platform    : ");
        builder.append(System.getProperty("os.name") + " ");
        builder.append(System.getProperty("os.arch") + " ");
        builder.append(System.getProperty("os.version"));
        builder.append("\n");
        return builder.toString();
    }

    public static class BookshelfOutputPreferences
    extends Output.OutputPreferences {
        public BookshelfOutputPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath, EditingPreferences ep) {
            BookshelfOutput output = new BookshelfOutput(filePath, ep);
            output.writeCell(cell, context);
            return output.finishWrite();
        }
    }
}

